--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 12.12.2019
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]


FillLevelLimiterEvent = {}

local FillLevelLimiterEvent_mt = Class(FillLevelLimiterEvent, Event)
InitEventClass(FillLevelLimiterEvent, "FillLevelLimiterEvent")

function FillLevelLimiterEvent:emptyNew()
    return Event.new(FillLevelLimiterEvent_mt)
end

function FillLevelLimiterEvent.new(object, limitsTable, showHelpInfo)
    local self = FillLevelLimiterEvent:emptyNew()

    self.object = object
    self.limitsTable = limitsTable
    self.showHelpInfo = showHelpInfo

    return self
end

function FillLevelLimiterEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)

    local numLimits = streamReadInt8(streamId)

    if numLimits > 0 then
        self.limitsTable = {}

        for i = 1, numLimits do
            local fillUnitIndex = streamReadUIntN(streamId, 8)
            local limit = streamReadFloat32(streamId)

            self.limitsTable[fillUnitIndex] = limit
        end
    end

    self.showHelpInfo = streamReadBool(streamId)
    self:run(connection)
end

function FillLevelLimiterEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)

    local numLimits = 0

    if self.limitsTable ~= nil then
        for _ in pairs (self.limitsTable) do
            numLimits = numLimits + 1
        end
    end

    streamWriteInt8(streamId, numLimits)

    if numLimits > 0 then
        for fillUnitIndex, limit in pairs (self.limitsTable) do
            streamWriteUIntN(streamId, fillUnitIndex, 8)
            streamWriteFloat32(streamId, limit)
        end
    end

    streamWriteBool(streamId, self.showHelpInfo)
end

function FillLevelLimiterEvent:run(connection)
    if self.object ~= nil and self.object.updateFillUnitLimits ~= nil then
        self.object:updateFillUnitLimits(self.limitsTable, self.showHelpInfo, true)

        if not connection:getIsServer() then
            g_server:broadcastEvent(FillLevelLimiterEvent.new(self.object, self.limitsTable, self.showHelpInfo), nil, connection, self.object)
        end
    end
end

function FillLevelLimiterEvent.sendEvent(vehicle, limitsTable, showHelpInfo, noEventSend)
    if vehicle.spec_fillLevelLimiter ~= nil and limitsTable ~= nil then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(FillLevelLimiterEvent.new(vehicle, limitsTable, showHelpInfo), nil, nil, vehicle)
            else
                g_client:getServerConnection():sendEvent(FillLevelLimiterEvent.new(vehicle, limitsTable, showHelpInfo))
            end
        end
    end
end
